@extends('layouts.core.backend', [
	'menu' => 'email_verification_plan',
])

@section('title', trans('messages.email_verification_plan.plans'))

@section('head')
    <script type="text/javascript" src="{{ AppUrl::asset('core/js/group-manager.js') }}"></script>
@endsection

@section('page_header')

    <div class="page-title" style="padding-bottom:0">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li class="breadcrumb-item"><a href="{{ action("Admin\HomeController@index") }}">{{ trans('messages.home') }}</a></li>
        </ul>
        <h1>
            <span class="text-semibold">{{ trans('messages.email_verification_plan.plans') }}</span>
        </h1>
    </div>

@endsection

@section('content')

    @include('admin.email_verification_plans._tabs', [
        'tab' => 'recurring',
    ])

    <div class="d-flex">
        <div class="pe-4 pe-lg-5"><p>{{ trans('messages.email_verification_plan.recurring.intro') }}</p></div>
        <div>
            @can('create', new Acelle\Model\PlanVerification())
                <div class="text-end text-nowrap">
                    <a href="{{ action('Admin\PlanVerificationController@create') }}" role="button" class="btn btn-primary">
                        <span class="material-symbols-rounded">add</span> {{ trans('messages.email_verification_plan.add_new_plan') }}
                    </a>
                </div>
            @endcan
        </div>
    </div>

    <div id="PlanVerificationContainer">
        <div class="d-flex top-list-controls top-sticky-content">
            <div class="me-auto">
                <div class="filter-box">
                    <span class="filter-group">
                        <span class="title text-semibold text-muted">{{ trans('messages.sort_by') }}</span>
                        <select class="select" name="sort_order">
                            <option value="email_verification_plans.name">{{ trans('messages.name') }}</option>
                            <option value="email_verification_plans.created_at">{{ trans('messages.created_at') }}</option>
                        </select>
                        <input type="hidden" name="sort_direction" value="asc" />
                                            <button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="{{ trans('messages.change_sort_direction') }}" role="button" class="btn btn-xs">
                            <span class="material-symbols-rounded desc">sort</span>
                        </button>
                    </span>
                    <span class="text-nowrap">
                        <input type="text" name="keyword" class="form-control search" value="{{ request()->keyword }}" placeholder="{{ trans('messages.type_to_search') }}" />
                        <span class="material-symbols-rounded">search</span>
                    </span>
                </div>
            </div>
        </div>

        <div id="PlanVerificationContent">
        </div>
    </div>

    <script>
        var PlanIndex = {
            getList: function() {
                return makeList({
                    url: '{{ action('Admin\PlanVerificationController@list') }}',
                    container: $('#PlanVerificationContainer'),
                    content: $('#PlanVerificationContent')
                });
            }
        };

        $(function() {
            PlanIndex.getList().load();
        });
    </script>
@endsection